@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.SubscriptionLogSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Part of Subscription diagnostic setting. Specifies the settings for a particular log.
 * @property category Name of a Subscription Diagnostic Log category for a resource type this setting is applied to.
 * @property categoryGroup Name of a Subscription Diagnostic Log category group for a resource type this setting is applied to.
 * @property enabled a value indicating whether this log is enabled.
 */
public data class SubscriptionLogSettingsArgs(
    public val category: Output<String>? = null,
    public val categoryGroup: Output<String>? = null,
    public val enabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.SubscriptionLogSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.SubscriptionLogSettingsArgs =
        com.pulumi.azurenative.insights.inputs.SubscriptionLogSettingsArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .categoryGroup(categoryGroup?.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriptionLogSettingsArgs].
 */
@PulumiTagMarker
public class SubscriptionLogSettingsArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var categoryGroup: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value Name of a Subscription Diagnostic Log category for a resource type this setting is applied to.
     */
    @JvmName("vfuprkeualaglpwa")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Name of a Subscription Diagnostic Log category group for a resource type this setting is applied to.
     */
    @JvmName("wknixfbdoxtexyfn")
    public suspend fun categoryGroup(`value`: Output<String>) {
        this.categoryGroup = value
    }

    /**
     * @param value a value indicating whether this log is enabled.
     */
    @JvmName("iurwjcttipfawfiv")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Name of a Subscription Diagnostic Log category for a resource type this setting is applied to.
     */
    @JvmName("mjclgyisrdmirvdl")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Name of a Subscription Diagnostic Log category group for a resource type this setting is applied to.
     */
    @JvmName("xovbcjjxarahncpo")
    public suspend fun categoryGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.categoryGroup = mapped
    }

    /**
     * @param value a value indicating whether this log is enabled.
     */
    @JvmName("xccnhbjbtwgwqrrd")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): SubscriptionLogSettingsArgs = SubscriptionLogSettingsArgs(
        category = category,
        categoryGroup = categoryGroup,
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
    )
}
