@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.WebTestPropertiesValidationRulesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The collection of validation rule properties
 * @property contentValidation The collection of content validation properties
 * @property expectedHttpStatusCode Validate that the WebTest returns the http status code provided.
 * @property ignoreHttpStatusCode When set, validation will ignore the status code.
 * @property sSLCertRemainingLifetimeCheck A number of days to check still remain before the the existing SSL cert expires.  Value must be positive and the SSLCheck must be set to true.
 * @property sSLCheck Checks to see if the SSL cert is still valid.
 */
public data class WebTestPropertiesValidationRulesArgs(
    public val contentValidation: Output<WebTestPropertiesContentValidationArgs>? = null,
    public val expectedHttpStatusCode: Output<Int>? = null,
    public val ignoreHttpStatusCode: Output<Boolean>? = null,
    public val sSLCertRemainingLifetimeCheck: Output<Int>? = null,
    public val sSLCheck: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.WebTestPropertiesValidationRulesArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.WebTestPropertiesValidationRulesArgs = com.pulumi.azurenative.insights.inputs.WebTestPropertiesValidationRulesArgs.builder()
        .contentValidation(contentValidation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .expectedHttpStatusCode(expectedHttpStatusCode?.applyValue({ args0 -> args0 }))
        .ignoreHttpStatusCode(ignoreHttpStatusCode?.applyValue({ args0 -> args0 }))
        .sSLCertRemainingLifetimeCheck(sSLCertRemainingLifetimeCheck?.applyValue({ args0 -> args0 }))
        .sSLCheck(sSLCheck?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebTestPropertiesValidationRulesArgs].
 */
@PulumiTagMarker
public class WebTestPropertiesValidationRulesArgsBuilder internal constructor() {
    private var contentValidation: Output<WebTestPropertiesContentValidationArgs>? = null

    private var expectedHttpStatusCode: Output<Int>? = null

    private var ignoreHttpStatusCode: Output<Boolean>? = null

    private var sSLCertRemainingLifetimeCheck: Output<Int>? = null

    private var sSLCheck: Output<Boolean>? = null

    /**
     * @param value The collection of content validation properties
     */
    @JvmName("yovyknltwbekbslo")
    public suspend fun contentValidation(`value`: Output<WebTestPropertiesContentValidationArgs>) {
        this.contentValidation = value
    }

    /**
     * @param value Validate that the WebTest returns the http status code provided.
     */
    @JvmName("yrvdhglltokmajud")
    public suspend fun expectedHttpStatusCode(`value`: Output<Int>) {
        this.expectedHttpStatusCode = value
    }

    /**
     * @param value When set, validation will ignore the status code.
     */
    @JvmName("crlootmpcrveqoxb")
    public suspend fun ignoreHttpStatusCode(`value`: Output<Boolean>) {
        this.ignoreHttpStatusCode = value
    }

    /**
     * @param value A number of days to check still remain before the the existing SSL cert expires.  Value must be positive and the SSLCheck must be set to true.
     */
    @JvmName("oltryekydmfdvtih")
    public suspend fun sSLCertRemainingLifetimeCheck(`value`: Output<Int>) {
        this.sSLCertRemainingLifetimeCheck = value
    }

    /**
     * @param value Checks to see if the SSL cert is still valid.
     */
    @JvmName("rldwghmumhhqbfdk")
    public suspend fun sSLCheck(`value`: Output<Boolean>) {
        this.sSLCheck = value
    }

    /**
     * @param value The collection of content validation properties
     */
    @JvmName("ahxjhriddwgwvjqf")
    public suspend fun contentValidation(`value`: WebTestPropertiesContentValidationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentValidation = mapped
    }

    /**
     * @param argument The collection of content validation properties
     */
    @JvmName("pbccvpjmtuqyoatt")
    public suspend fun contentValidation(argument: suspend WebTestPropertiesContentValidationArgsBuilder.() -> Unit) {
        val toBeMapped = WebTestPropertiesContentValidationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.contentValidation = mapped
    }

    /**
     * @param value Validate that the WebTest returns the http status code provided.
     */
    @JvmName("elgwicqmqyolluvp")
    public suspend fun expectedHttpStatusCode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedHttpStatusCode = mapped
    }

    /**
     * @param value When set, validation will ignore the status code.
     */
    @JvmName("hfwdpwvadfpmnery")
    public suspend fun ignoreHttpStatusCode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreHttpStatusCode = mapped
    }

    /**
     * @param value A number of days to check still remain before the the existing SSL cert expires.  Value must be positive and the SSLCheck must be set to true.
     */
    @JvmName("ccwtqsoblqvejkic")
    public suspend fun sSLCertRemainingLifetimeCheck(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sSLCertRemainingLifetimeCheck = mapped
    }

    /**
     * @param value Checks to see if the SSL cert is still valid.
     */
    @JvmName("ejcgaeqqejtoftwb")
    public suspend fun sSLCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sSLCheck = mapped
    }

    internal fun build(): WebTestPropertiesValidationRulesArgs = WebTestPropertiesValidationRulesArgs(
        contentValidation = contentValidation,
        expectedHttpStatusCode = expectedHttpStatusCode,
        ignoreHttpStatusCode = ignoreHttpStatusCode,
        sSLCertRemainingLifetimeCheck = sSLCertRemainingLifetimeCheck,
        sSLCheck = sSLCheck,
    )
}
