@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.WindowsEventLogDataSourceArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.KnownWindowsEventLogDataSourceStreams
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Definition of which Windows Event Log events will be collected and how they will be collected.
 * Only collected from Windows machines.
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property streams List of streams that this data source will be sent to.
 * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
 * @property xPathQueries A list of Windows Event Log queries in XPATH format.
 */
public data class WindowsEventLogDataSourceArgs(
    public val name: Output<String>? = null,
    public val streams: Output<List<Either<String, KnownWindowsEventLogDataSourceStreams>>>? = null,
    public val xPathQueries: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.WindowsEventLogDataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.WindowsEventLogDataSourceArgs =
        com.pulumi.azurenative.insights.inputs.WindowsEventLogDataSourceArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .streams(
                streams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .xPathQueries(xPathQueries?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WindowsEventLogDataSourceArgs].
 */
@PulumiTagMarker
public class WindowsEventLogDataSourceArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var streams: Output<List<Either<String, KnownWindowsEventLogDataSourceStreams>>>? = null

    private var xPathQueries: Output<List<String>>? = null

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("ehggwnheuytwkpki")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
     */
    @JvmName("cmuuioqpnmpbdrcr")
    public suspend fun streams(`value`: Output<List<Either<String, KnownWindowsEventLogDataSourceStreams>>>) {
        this.streams = value
    }

    @JvmName("spwuxiamidruwvww")
    public suspend fun streams(vararg values: Output<Either<String, KnownWindowsEventLogDataSourceStreams>>) {
        this.streams = Output.all(values.asList())
    }

    /**
     * @param values List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
     */
    @JvmName("mddrsbcmwcncdtbg")
    public suspend fun streams(values: List<Output<Either<String, KnownWindowsEventLogDataSourceStreams>>>) {
        this.streams = Output.all(values)
    }

    /**
     * @param value A list of Windows Event Log queries in XPATH format.
     */
    @JvmName("nbmjjawtcovdbpvo")
    public suspend fun xPathQueries(`value`: Output<List<String>>) {
        this.xPathQueries = value
    }

    @JvmName("bfsdttdbthcifydg")
    public suspend fun xPathQueries(vararg values: Output<String>) {
        this.xPathQueries = Output.all(values.asList())
    }

    /**
     * @param values A list of Windows Event Log queries in XPATH format.
     */
    @JvmName("dehugtmjctyfellc")
    public suspend fun xPathQueries(values: List<Output<String>>) {
        this.xPathQueries = Output.all(values)
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("rgnrmotrkscgqulk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
     */
    @JvmName("fmguxqjwestgpqwn")
    public suspend fun streams(`value`: List<Either<String, KnownWindowsEventLogDataSourceStreams>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    /**
     * @param values List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
     */
    @JvmName("keteurvgjgmaxvbo")
    public suspend fun streams(vararg values: Either<String, KnownWindowsEventLogDataSourceStreams>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    /**
     * @param value A list of Windows Event Log queries in XPATH format.
     */
    @JvmName("yoxteacyyjcteqjs")
    public suspend fun xPathQueries(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xPathQueries = mapped
    }

    /**
     * @param values A list of Windows Event Log queries in XPATH format.
     */
    @JvmName("ulelbtkkigqgeyfc")
    public suspend fun xPathQueries(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.xPathQueries = mapped
    }

    internal fun build(): WindowsEventLogDataSourceArgs = WindowsEventLogDataSourceArgs(
        name = name,
        streams = streams,
        xPathQueries = xPathQueries,
    )
}
