@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties that define the scope private link mode settings exclusion item. This setting applies to a specific private endpoint connection and overrides the default settings for that private endpoint connection.
 * @property ingestionAccessMode Specifies the access mode of ingestion through the specified private endpoint connection in the exclusion.
 * @property privateEndpointConnectionName The private endpoint connection name associated to the private endpoint on which we want to apply the specific access mode settings.
 * @property queryAccessMode Specifies the access mode of queries through the specified private endpoint connection in the exclusion.
 */
public data class AccessModeSettingsExclusionResponse(
    public val ingestionAccessMode: String? = null,
    public val privateEndpointConnectionName: String? = null,
    public val queryAccessMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.AccessModeSettingsExclusionResponse): AccessModeSettingsExclusionResponse = AccessModeSettingsExclusionResponse(
            ingestionAccessMode = javaType.ingestionAccessMode().map({ args0 -> args0 }).orElse(null),
            privateEndpointConnectionName = javaType.privateEndpointConnectionName().map({ args0 ->
                args0
            }).orElse(null),
            queryAccessMode = javaType.queryAccessMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
