@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties that define the scope private link mode settings.
 * @property exclusions List of exclusions that override the default access mode settings for specific private endpoint connections.
 * @property ingestionAccessMode Specifies the default access mode of ingestion through associated private endpoints in scope. If not specified default value is 'Open'. You can override this default setting for a specific private endpoint connection by adding an exclusion in the 'exclusions' array.
 * @property queryAccessMode Specifies the default access mode of queries through associated private endpoints in scope. If not specified default value is 'Open'. You can override this default setting for a specific private endpoint connection by adding an exclusion in the 'exclusions' array.
 */
public data class AccessModeSettingsResponse(
    public val exclusions: List<AccessModeSettingsExclusionResponse>? = null,
    public val ingestionAccessMode: String,
    public val queryAccessMode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.AccessModeSettingsResponse): AccessModeSettingsResponse = AccessModeSettingsResponse(
            exclusions = javaType.exclusions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.AccessModeSettingsExclusionResponse.Companion.toKotlin(args0)
                })
            }),
            ingestionAccessMode = javaType.ingestionAccessMode(),
            queryAccessMode = javaType.queryAccessMode(),
        )
    }
}
