@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An Activity Log Alert rule condition that is met when all its member conditions are met.
 * Each condition can be of one of the following types:
 * __Important__: Each type has its unique subset of properties. Properties from different types CANNOT exist in one condition.
 *    * __Leaf Condition -__ must contain 'field' and either 'equals' or 'containsAny'.
 *   _Please note, 'anyOf' should __not__ be set in a Leaf Condition._
 *   * __AnyOf Condition -__ must contain __only__ 'anyOf' (which is an array of Leaf Conditions).
 *   _Please note, 'field', 'equals' and 'containsAny' should __not__ be set in an AnyOf Condition._
 * @property anyOf An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
 * @property containsAny The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
 * @property equals The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
 * @property field The name of the Activity Log event's field that this condition will examine.
 * The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
 */
public data class AlertRuleAnyOfOrLeafConditionResponse(
    public val anyOf: List<AlertRuleLeafConditionResponse>? = null,
    public val containsAny: List<String>? = null,
    public val equals: String? = null,
    public val `field`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.AlertRuleAnyOfOrLeafConditionResponse): AlertRuleAnyOfOrLeafConditionResponse = AlertRuleAnyOfOrLeafConditionResponse(
            anyOf = javaType.anyOf().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.AlertRuleLeafConditionResponse.Companion.toKotlin(args0)
                })
            }),
            containsAny = javaType.containsAny().map({ args0 -> args0 }),
            equals = javaType.equals_().map({ args0 -> args0 }).orElse(null),
            `field` = javaType.`field`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
