@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 * An Application Insights component daily data volume cap
 * @property cap Daily data volume cap in GB.
 * @property maxHistoryCap Maximum daily data volume cap that the user can set for this component.
 * @property resetTime Daily data volume cap UTC reset hour.
 * @property stopSendNotificationWhenHitCap Do not send a notification email when the daily data volume cap is met.
 * @property stopSendNotificationWhenHitThreshold Reserved, not used for now.
 * @property warningThreshold Reserved, not used for now.
 */
public data class ApplicationInsightsComponentDataVolumeCapResponse(
    public val cap: Double? = null,
    public val maxHistoryCap: Double,
    public val resetTime: Int,
    public val stopSendNotificationWhenHitCap: Boolean? = null,
    public val stopSendNotificationWhenHitThreshold: Boolean? = null,
    public val warningThreshold: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ApplicationInsightsComponentDataVolumeCapResponse): ApplicationInsightsComponentDataVolumeCapResponse =
            ApplicationInsightsComponentDataVolumeCapResponse(
                cap = javaType.cap().map({ args0 -> args0 }).orElse(null),
                maxHistoryCap = javaType.maxHistoryCap(),
                resetTime = javaType.resetTime(),
                stopSendNotificationWhenHitCap = javaType.stopSendNotificationWhenHitCap().map({ args0 ->
                    args0
                }).orElse(null),
                stopSendNotificationWhenHitThreshold = javaType.stopSendNotificationWhenHitThreshold().map({ args0 ->
                    args0
                }).orElse(null),
                warningThreshold = javaType.warningThreshold().map({ args0 -> args0 }).orElse(null),
            )
    }
}
