@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Static definitions of the ProactiveDetection configuration rule (same values for all components).
 * @property description The rule description
 * @property displayName The rule name as it is displayed in UI
 * @property helpUrl URL which displays additional info about the proactive detection rule
 * @property isEnabledByDefault A flag indicating whether the rule is enabled by default
 * @property isHidden A flag indicating whether the rule is hidden (from the UI)
 * @property isInPreview A flag indicating whether the rule is in preview
 * @property name The rule name
 * @property supportsEmailNotifications A flag indicating whether email notifications are supported for detections for this rule
 */
public data class
ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesResponseRuleDefinitions(
    public val description: String? = null,
    public val displayName: String? = null,
    public val helpUrl: String? = null,
    public val isEnabledByDefault: Boolean? = null,
    public val isHidden: Boolean? = null,
    public val isInPreview: Boolean? = null,
    public val name: String? = null,
    public val supportsEmailNotifications: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesResponseRuleDefinitions): ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesResponseRuleDefinitions =
            ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesResponseRuleDefinitions(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
                helpUrl = javaType.helpUrl().map({ args0 -> args0 }).orElse(null),
                isEnabledByDefault = javaType.isEnabledByDefault().map({ args0 -> args0 }).orElse(null),
                isHidden = javaType.isHidden().map({ args0 -> args0 }).orElse(null),
                isInPreview = javaType.isInPreview().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                supportsEmailNotifications = javaType.supportsEmailNotifications().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
