@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * An arm role receiver.
 * @property name The name of the arm role receiver. Names must be unique across all receivers within an action group.
 * @property roleId The arm role id.
 * @property useCommonAlertSchema Indicates whether to use common alert schema.
 */
public data class ArmRoleReceiverResponse(
    public val name: String,
    public val roleId: String,
    public val useCommonAlertSchema: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ArmRoleReceiverResponse): ArmRoleReceiverResponse = ArmRoleReceiverResponse(
            name = javaType.name(),
            roleId = javaType.roleId(),
            useCommonAlertSchema = javaType.useCommonAlertSchema().map({ args0 -> args0 }).orElse(null),
        )
    }
}
