@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The Azure Automation Runbook notification receiver.
 * @property automationAccountId The Azure automation account Id which holds this runbook and authenticate to Azure resource.
 * @property isGlobalRunbook Indicates whether this instance is global runbook.
 * @property name Indicates name of the webhook.
 * @property runbookName The name for this runbook.
 * @property serviceUri The URI where webhooks should be sent.
 * @property useCommonAlertSchema Indicates whether to use common alert schema.
 * @property webhookResourceId The resource id for webhook linked to this runbook.
 */
public data class AutomationRunbookReceiverResponse(
    public val automationAccountId: String,
    public val isGlobalRunbook: Boolean,
    public val name: String? = null,
    public val runbookName: String,
    public val serviceUri: String? = null,
    public val useCommonAlertSchema: Boolean? = null,
    public val webhookResourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.AutomationRunbookReceiverResponse): AutomationRunbookReceiverResponse = AutomationRunbookReceiverResponse(
            automationAccountId = javaType.automationAccountId(),
            isGlobalRunbook = javaType.isGlobalRunbook(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            runbookName = javaType.runbookName(),
            serviceUri = javaType.serviceUri().map({ args0 -> args0 }).orElse(null),
            useCommonAlertSchema = javaType.useCommonAlertSchema().map({ args0 -> args0 }).orElse(null),
            webhookResourceId = javaType.webhookResourceId(),
        )
    }
}
