@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Autoscale notification.
 * @property email the email notification.
 * @property operation the operation associated with the notification and its value must be "scale"
 * @property webhooks the collection of webhook notifications.
 */
public data class AutoscaleNotificationResponse(
    public val email: EmailNotificationResponse? = null,
    public val operation: String,
    public val webhooks: List<WebhookNotificationResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.AutoscaleNotificationResponse): AutoscaleNotificationResponse = AutoscaleNotificationResponse(
            email = javaType.email().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.EmailNotificationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            operation = javaType.operation(),
            webhooks = javaType.webhooks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.WebhookNotificationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
