@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Autoscale profile.
 * @property capacity the number of instances that can be used during this profile.
 * @property fixedDate the specific date-time for the profile. This element is not used if the Recurrence element is used.
 * @property name the name of the profile.
 * @property recurrence the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
 * @property rules the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
 */
public data class AutoscaleProfileResponse(
    public val capacity: ScaleCapacityResponse,
    public val fixedDate: TimeWindowResponse? = null,
    public val name: String,
    public val recurrence: RecurrenceResponse? = null,
    public val rules: List<ScaleRuleResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.AutoscaleProfileResponse): AutoscaleProfileResponse = AutoscaleProfileResponse(
            capacity = javaType.capacity().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.ScaleCapacityResponse.Companion.toKotlin(args0)
            }),
            fixedDate = javaType.fixedDate().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.TimeWindowResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            recurrence = javaType.recurrence().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.RecurrenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.ScaleRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
