@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Azure mobile App push notification receiver.
 * @property emailAddress The email address registered for the Azure mobile app.
 * @property name The name of the Azure mobile app push receiver. Names must be unique across all receivers within a tenant action group.
 */
public data class AzureAppPushReceiverResponse(
    public val emailAddress: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.AzureAppPushReceiverResponse): AzureAppPushReceiverResponse = AzureAppPushReceiverResponse(
            emailAddress = javaType.emailAddress(),
            name = javaType.name(),
        )
    }
}
