@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * An azure function receiver.
 * @property functionAppResourceId The azure resource id of the function app.
 * @property functionName The function name in the function app.
 * @property httpTriggerUrl The http trigger url where http request sent to.
 * @property name The name of the azure function receiver. Names must be unique across all receivers within an action group.
 * @property useCommonAlertSchema Indicates whether to use common alert schema.
 */
public data class AzureFunctionReceiverResponse(
    public val functionAppResourceId: String,
    public val functionName: String,
    public val httpTriggerUrl: String,
    public val name: String,
    public val useCommonAlertSchema: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.AzureFunctionReceiverResponse): AzureFunctionReceiverResponse = AzureFunctionReceiverResponse(
            functionAppResourceId = javaType.functionAppResourceId(),
            functionName = javaType.functionName(),
            httpTriggerUrl = javaType.httpTriggerUrl(),
            name = javaType.name(),
            useCommonAlertSchema = javaType.useCommonAlertSchema().map({ args0 -> args0 }).orElse(null),
        )
    }
}
