@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Network access control rules for the endpoints.
 * @property publicNetworkAccess The configuration to set whether network access from public internet to the endpoints are allowed.
 */
public data class DataCollectionEndpointResponseNetworkAcls(
    public val publicNetworkAccess: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.DataCollectionEndpointResponseNetworkAcls): DataCollectionEndpointResponseNetworkAcls = DataCollectionEndpointResponseNetworkAcls(
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
        )
    }
}
