@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The specification of destinations.
 * @property azureMonitorMetrics Azure Monitor Metrics destination.
 * @property eventHubs List of Event Hubs destinations.
 * @property eventHubsDirect List of Event Hubs Direct destinations.
 * @property logAnalytics List of Log Analytics destinations.
 * @property monitoringAccounts List of monitoring account destinations.
 * @property storageAccounts List of storage accounts destinations.
 * @property storageBlobsDirect List of Storage Blob Direct destinations. To be used only for sending data directly to store from the agent.
 * @property storageTablesDirect List of Storage Table Direct destinations.
 */
public data class DataCollectionRuleResponseDestinations(
    public val azureMonitorMetrics: DestinationsSpecResponseAzureMonitorMetrics? = null,
    public val eventHubs: List<EventHubDestinationResponse>? = null,
    public val eventHubsDirect: List<EventHubDirectDestinationResponse>? = null,
    public val logAnalytics: List<LogAnalyticsDestinationResponse>? = null,
    public val monitoringAccounts: List<MonitoringAccountDestinationResponse>? = null,
    public val storageAccounts: List<StorageBlobDestinationResponse>? = null,
    public val storageBlobsDirect: List<StorageBlobDestinationResponse>? = null,
    public val storageTablesDirect: List<StorageTableDestinationResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.DataCollectionRuleResponseDestinations): DataCollectionRuleResponseDestinations = DataCollectionRuleResponseDestinations(
            azureMonitorMetrics = javaType.azureMonitorMetrics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.DestinationsSpecResponseAzureMonitorMetrics.Companion.toKotlin(args0)
                })
            }).orElse(null),
            eventHubs = javaType.eventHubs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.EventHubDestinationResponse.Companion.toKotlin(args0)
                })
            }),
            eventHubsDirect = javaType.eventHubsDirect().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.EventHubDirectDestinationResponse.Companion.toKotlin(args0)
                })
            }),
            logAnalytics = javaType.logAnalytics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.LogAnalyticsDestinationResponse.Companion.toKotlin(args0)
                })
            }),
            monitoringAccounts = javaType.monitoringAccounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.MonitoringAccountDestinationResponse.Companion.toKotlin(args0)
                })
            }),
            storageAccounts = javaType.storageAccounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.StorageBlobDestinationResponse.Companion.toKotlin(args0)
                })
            }),
            storageBlobsDirect = javaType.storageBlobsDirect().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.StorageBlobDestinationResponse.Companion.toKotlin(args0)
                })
            }),
            storageTablesDirect = javaType.storageTablesDirect().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.StorageTableDestinationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
