@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Definition of which streams are sent to which destinations.
 * @property builtInTransform The builtIn transform to transform stream data
 * @property destinations List of destinations for this data flow.
 * @property outputStream The output stream of the transform. Only required if the transform changes data to a different stream.
 * @property streams List of streams for this data flow.
 * @property transformKql The KQL query to transform stream data.
 */
public data class DataFlowResponse(
    public val builtInTransform: String? = null,
    public val destinations: List<String>? = null,
    public val outputStream: String? = null,
    public val streams: List<String>? = null,
    public val transformKql: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.DataFlowResponse): DataFlowResponse = DataFlowResponse(
            builtInTransform = javaType.builtInTransform().map({ args0 -> args0 }).orElse(null),
            destinations = javaType.destinations().map({ args0 -> args0 }),
            outputStream = javaType.outputStream().map({ args0 -> args0 }).orElse(null),
            streams = javaType.streams().map({ args0 -> args0 }),
            transformKql = javaType.transformKql().map({ args0 -> args0 }).orElse(null),
        )
    }
}
