@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of Event Hub configuration.
 * @property consumerGroup Event Hub consumer group name
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property stream The stream to collect from EventHub
 */
public data class DataImportSourcesResponseEventHub(
    public val consumerGroup: String? = null,
    public val name: String? = null,
    public val stream: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.DataImportSourcesResponseEventHub): DataImportSourcesResponseEventHub = DataImportSourcesResponseEventHub(
            consumerGroup = javaType.consumerGroup().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            stream = javaType.stream().map({ args0 -> args0 }).orElse(null),
        )
    }
}
