@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The diagnostic settings category resource.
 * @property categoryGroups the collection of what category groups are supported.
 * @property categoryType The type of the diagnostic settings category.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property systemData The system metadata related to this resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class DiagnosticSettingsCategoryResourceResponse(
    public val categoryGroups: List<String>? = null,
    public val categoryType: String? = null,
    public val id: String,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.DiagnosticSettingsCategoryResourceResponse): DiagnosticSettingsCategoryResourceResponse = DiagnosticSettingsCategoryResourceResponse(
            categoryGroups = javaType.categoryGroups().map({ args0 -> args0 }),
            categoryType = javaType.categoryType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
