@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Criterion for dynamic threshold.
 * @property alertSensitivity The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern.
 * @property criterionType Specifies the type of threshold criteria
 * Expected value is 'DynamicThresholdCriterion'.
 * @property dimensions List of dimension conditions.
 * @property failingPeriods The minimum number of violations required within the selected lookback time window required to raise an alert.
 * @property ignoreDataBefore Use this option to set the date from which to start learning the metric historical data and calculate the dynamic thresholds (in ISO8601 format)
 * @property metricName Name of the metric.
 * @property metricNamespace Namespace of the metric.
 * @property name Name of the criteria.
 * @property operator The operator used to compare the metric value against the threshold.
 * @property skipMetricValidation Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
 * @property timeAggregation the criteria time aggregation types.
 */
public data class DynamicMetricCriteriaResponse(
    public val alertSensitivity: String,
    public val criterionType: String,
    public val dimensions: List<MetricDimensionResponse>? = null,
    public val failingPeriods: DynamicThresholdFailingPeriodsResponse,
    public val ignoreDataBefore: String? = null,
    public val metricName: String,
    public val metricNamespace: String? = null,
    public val name: String,
    public val `operator`: String,
    public val skipMetricValidation: Boolean? = null,
    public val timeAggregation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.DynamicMetricCriteriaResponse): DynamicMetricCriteriaResponse = DynamicMetricCriteriaResponse(
            alertSensitivity = javaType.alertSensitivity(),
            criterionType = javaType.criterionType(),
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.MetricDimensionResponse.Companion.toKotlin(args0)
                })
            }),
            failingPeriods = javaType.failingPeriods().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.DynamicThresholdFailingPeriodsResponse.Companion.toKotlin(args0)
            }),
            ignoreDataBefore = javaType.ignoreDataBefore().map({ args0 -> args0 }).orElse(null),
            metricName = javaType.metricName(),
            metricNamespace = javaType.metricNamespace().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            `operator` = javaType.`operator`(),
            skipMetricValidation = javaType.skipMetricValidation().map({ args0 -> args0 }).orElse(null),
            timeAggregation = javaType.timeAggregation(),
        )
    }
}
