@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * An email receiver.
 * @property emailAddress The email address of this receiver.
 * @property name The name of the email receiver. Names must be unique across all receivers within a tenant action group.
 * @property status The receiver status of the e-mail.
 * @property useCommonAlertSchema Indicates whether to use common alert schema.
 */
public data class EmailReceiverResponse(
    public val emailAddress: String,
    public val name: String,
    public val status: String,
    public val useCommonAlertSchema: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.EmailReceiverResponse): EmailReceiverResponse = EmailReceiverResponse(
            emailAddress = javaType.emailAddress(),
            name = javaType.name(),
            status = javaType.status(),
            useCommonAlertSchema = javaType.useCommonAlertSchema().map({ args0 -> args0 }).orElse(null),
        )
    }
}
