@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * An Event hub receiver.
 * @property eventHubName The name of the specific Event Hub queue
 * @property eventHubNameSpace The Event Hub namespace
 * @property name The name of the Event hub receiver. Names must be unique across all receivers within an action group.
 * @property subscriptionId The Id for the subscription containing this event hub
 * @property tenantId The tenant Id for the subscription containing this event hub
 * @property useCommonAlertSchema Indicates whether to use common alert schema.
 */
public data class EventHubReceiverResponse(
    public val eventHubName: String,
    public val eventHubNameSpace: String,
    public val name: String,
    public val subscriptionId: String,
    public val tenantId: String? = null,
    public val useCommonAlertSchema: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.EventHubReceiverResponse): EventHubReceiverResponse = EventHubReceiverResponse(
            eventHubName = javaType.eventHubName(),
            eventHubNameSpace = javaType.eventHubNameSpace(),
            name = javaType.name(),
            subscriptionId = javaType.subscriptionId(),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            useCommonAlertSchema = javaType.useCommonAlertSchema().map({ args0 -> args0 }).orElse(null),
        )
    }
}
