@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An action group resource.
 * @property armRoleReceivers The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
 * @property automationRunbookReceivers The list of AutomationRunbook receivers that are part of this action group.
 * @property azureAppPushReceivers The list of AzureAppPush receivers that are part of this action group.
 * @property azureFunctionReceivers The list of azure function receivers that are part of this action group.
 * @property emailReceivers The list of email receivers that are part of this action group.
 * @property enabled Indicates whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications.
 * @property eventHubReceivers The list of event hub receivers that are part of this action group.
 * @property groupShortName The short name of the action group. This will be used in SMS messages.
 * @property id Azure resource Id
 * @property itsmReceivers The list of ITSM receivers that are part of this action group.
 * @property location Resource location
 * @property logicAppReceivers The list of logic app receivers that are part of this action group.
 * @property name Azure resource name
 * @property smsReceivers The list of SMS receivers that are part of this action group.
 * @property tags Resource tags
 * @property type Azure resource type
 * @property voiceReceivers The list of voice receivers that are part of this action group.
 * @property webhookReceivers The list of webhook receivers that are part of this action group.
 */
public data class GetActionGroupResult(
    public val armRoleReceivers: List<ArmRoleReceiverResponse>? = null,
    public val automationRunbookReceivers: List<AutomationRunbookReceiverResponse>? = null,
    public val azureAppPushReceivers: List<AzureAppPushReceiverResponse>? = null,
    public val azureFunctionReceivers: List<AzureFunctionReceiverResponse>? = null,
    public val emailReceivers: List<EmailReceiverResponse>? = null,
    public val enabled: Boolean,
    public val eventHubReceivers: List<EventHubReceiverResponse>? = null,
    public val groupShortName: String,
    public val id: String,
    public val itsmReceivers: List<ItsmReceiverResponse>? = null,
    public val location: String,
    public val logicAppReceivers: List<LogicAppReceiverResponse>? = null,
    public val name: String,
    public val smsReceivers: List<SmsReceiverResponse>? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val voiceReceivers: List<VoiceReceiverResponse>? = null,
    public val webhookReceivers: List<WebhookReceiverResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetActionGroupResult): GetActionGroupResult = GetActionGroupResult(
            armRoleReceivers = javaType.armRoleReceivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.ArmRoleReceiverResponse.Companion.toKotlin(args0)
                })
            }),
            automationRunbookReceivers = javaType.automationRunbookReceivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.AutomationRunbookReceiverResponse.Companion.toKotlin(args0)
                })
            }),
            azureAppPushReceivers = javaType.azureAppPushReceivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.AzureAppPushReceiverResponse.Companion.toKotlin(args0)
                })
            }),
            azureFunctionReceivers = javaType.azureFunctionReceivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.AzureFunctionReceiverResponse.Companion.toKotlin(args0)
                })
            }),
            emailReceivers = javaType.emailReceivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.EmailReceiverResponse.Companion.toKotlin(args0)
                })
            }),
            enabled = javaType.enabled(),
            eventHubReceivers = javaType.eventHubReceivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.EventHubReceiverResponse.Companion.toKotlin(args0)
                })
            }),
            groupShortName = javaType.groupShortName(),
            id = javaType.id(),
            itsmReceivers = javaType.itsmReceivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.ItsmReceiverResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            logicAppReceivers = javaType.logicAppReceivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.LogicAppReceiverResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            smsReceivers = javaType.smsReceivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.SmsReceiverResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            voiceReceivers = javaType.voiceReceivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.VoiceReceiverResponse.Companion.toKotlin(args0)
                })
            }),
            webhookReceivers = javaType.webhookReceivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.WebhookReceiverResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
