@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The alert rule resource.
 * @property action action that is performed when the alert rule becomes active, and when an alert condition is resolved.
 * @property actions the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
 * @property condition the condition that results in the alert rule being activated.
 * @property description the description of the alert rule that will be included in the alert email.
 * @property id Azure resource Id
 * @property isEnabled the flag that indicates whether the alert rule is enabled.
 * @property lastUpdatedTime Last time the rule was updated in ISO8601 format.
 * @property location Resource location
 * @property name Azure resource name
 * @property provisioningState the provisioning state.
 * @property tags Resource tags
 * @property type Azure resource type
 */
public data class GetAlertRuleResult(
    public val action: Either<RuleEmailActionResponse, RuleWebhookActionResponse>? = null,
    public val actions: List<Either<RuleEmailActionResponse, RuleWebhookActionResponse>>? = null,
    public val condition: Any,
    public val description: String? = null,
    public val id: String,
    public val isEnabled: Boolean,
    public val lastUpdatedTime: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetAlertRuleResult): GetAlertRuleResult = GetAlertRuleResult(
            action = javaType.action().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.insights.kotlin.outputs.RuleEmailActionResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.insights.kotlin.outputs.RuleWebhookActionResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            actions = javaType.actions().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.insights.kotlin.outputs.RuleEmailActionResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.insights.kotlin.outputs.RuleWebhookActionResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }),
            condition = javaType.condition(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isEnabled = javaType.isEnabled(),
            lastUpdatedTime = javaType.lastUpdatedTime(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
