@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties that define an Analytics item that is associated to an Application Insights component.
 * @property content The content of this item
 * @property id Internally assigned unique id of the item definition.
 * @property name The user-defined name of the item.
 * @property properties A set of properties that can be defined in the context of a specific item type. Each type may have its own properties.
 * @property scope Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component.
 * @property timeCreated Date and time in UTC when this item was created.
 * @property timeModified Date and time in UTC of the last modification that was made to this item.
 * @property type Enum indicating the type of the Analytics item.
 * @property version This instance's version of the data model. This can change as new features are added.
 */
public data class GetAnalyticsItemResult(
    public val content: String? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val properties: ApplicationInsightsComponentAnalyticsItemPropertiesResponse,
    public val scope: String? = null,
    public val timeCreated: String,
    public val timeModified: String,
    public val type: String? = null,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetAnalyticsItemResult): GetAnalyticsItemResult = GetAnalyticsItemResult(
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.ApplicationInsightsComponentAnalyticsItemPropertiesResponse.Companion.toKotlin(args0)
            }),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            timeCreated = javaType.timeCreated(),
            timeModified = javaType.timeModified(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            version = javaType.version(),
        )
    }
}
