@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The autoscale setting resource.
 * @property enabled the enabled flag. Specifies whether automatic scaling is enabled for the resource. The default value is 'false'.
 * @property id Azure resource Id
 * @property location Resource location
 * @property name Azure resource name
 * @property notifications the collection of notifications.
 * @property predictiveAutoscalePolicy the predictive autoscale policy mode.
 * @property profiles the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified.
 * @property systemData The system metadata related to the response.
 * @property tags Gets or sets a list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater in length than 128 characters and a value no greater in length than 256 characters.
 * @property targetResourceLocation the location of the resource that the autoscale setting should be added to.
 * @property targetResourceUri the resource identifier of the resource that the autoscale setting should be added to.
 * @property type Azure resource type
 */
public data class GetAutoscaleSettingResult(
    public val enabled: Boolean? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val notifications: List<AutoscaleNotificationResponse>? = null,
    public val predictiveAutoscalePolicy: PredictiveAutoscalePolicyResponse? = null,
    public val profiles: List<AutoscaleProfileResponse>,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val targetResourceLocation: String? = null,
    public val targetResourceUri: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetAutoscaleSettingResult): GetAutoscaleSettingResult = GetAutoscaleSettingResult(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            notifications = javaType.notifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.AutoscaleNotificationResponse.Companion.toKotlin(args0)
                })
            }),
            predictiveAutoscalePolicy = javaType.predictiveAutoscalePolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.PredictiveAutoscalePolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            profiles = javaType.profiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.AutoscaleProfileResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetResourceLocation = javaType.targetResourceLocation().map({ args0 -> args0 }).orElse(null),
            targetResourceUri = javaType.targetResourceUri().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
