@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An Application Insights component definition.
 * @property appId Application Insights Unique ID for your Application.
 * @property applicationId The unique ID of your application. This field mirrors the 'Name' field and cannot be changed.
 * @property applicationType Type of application being monitored.
 * @property connectionString Application Insights component connection string.
 * @property creationDate Creation Date for the Application Insights component, in ISO 8601 format.
 * @property disableIpMasking Disable IP masking.
 * @property disableLocalAuth Disable Non-AAD based Auth.
 * @property etag Resource etag
 * @property flowType Used by the Application Insights system to determine what kind of flow this component was created by. This is to be set to 'Bluefield' when creating/updating a component via the REST API.
 * @property forceCustomerStorageForProfiler Force users to create their own storage account for profiler and debugger.
 * @property hockeyAppId The unique application ID created when a new application is added to HockeyApp, used for communications with HockeyApp.
 * @property hockeyAppToken Token used to authenticate communications with between Application Insights and HockeyApp.
 * @property id Azure resource Id
 * @property immediatePurgeDataOn30Days Purge data immediately after 30 days.
 * @property ingestionMode Indicates the flow of the ingestion.
 * @property instrumentationKey Application Insights Instrumentation key. A read-only value that applications can use to identify the destination for all telemetry sent to Azure Application Insights. This value will be supplied upon construction of each new Application Insights component.
 * @property kind The kind of application that this component refers to, used to customize UI. This value is a freeform string, values should typically be one of the following: web, ios, other, store, java, phone.
 * @property laMigrationDate The date which the component got migrated to LA, in ISO 8601 format.
 * @property location Resource location
 * @property name Azure resource name
 * @property privateLinkScopedResources List of linked private link scope resources.
 * @property provisioningState Current state of this component: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
 * @property publicNetworkAccessForIngestion The network access type for accessing Application Insights ingestion.
 * @property publicNetworkAccessForQuery The network access type for accessing Application Insights query.
 * @property requestSource Describes what tool created this Application Insights component. Customers using this API should set this to the default 'rest'.
 * @property retentionInDays Retention period in days.
 * @property samplingPercentage Percentage of the data produced by the application being monitored that is being sampled for Application Insights telemetry.
 * @property tags Resource tags
 * @property tenantId Azure Tenant Id.
 * @property type Azure resource type
 * @property workspaceResourceId Resource Id of the log analytics workspace which the data will be ingested to. This property is required to create an application with this API version. Applications from older versions will not have this property.
 */
public data class GetComponentResult(
    public val appId: String,
    public val applicationId: String,
    public val applicationType: String,
    public val connectionString: String,
    public val creationDate: String,
    public val disableIpMasking: Boolean? = null,
    public val disableLocalAuth: Boolean? = null,
    public val etag: String? = null,
    public val flowType: String? = null,
    public val forceCustomerStorageForProfiler: Boolean? = null,
    public val hockeyAppId: String? = null,
    public val hockeyAppToken: String,
    public val id: String,
    public val immediatePurgeDataOn30Days: Boolean? = null,
    public val ingestionMode: String? = null,
    public val instrumentationKey: String,
    public val kind: String,
    public val laMigrationDate: String,
    public val location: String,
    public val name: String,
    public val privateLinkScopedResources: List<PrivateLinkScopedResourceResponse>,
    public val provisioningState: String,
    public val publicNetworkAccessForIngestion: String? = null,
    public val publicNetworkAccessForQuery: String? = null,
    public val requestSource: String? = null,
    public val retentionInDays: Int? = null,
    public val samplingPercentage: Double? = null,
    public val tags: Map<String, String>? = null,
    public val tenantId: String,
    public val type: String,
    public val workspaceResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetComponentResult): GetComponentResult = GetComponentResult(
            appId = javaType.appId(),
            applicationId = javaType.applicationId(),
            applicationType = javaType.applicationType(),
            connectionString = javaType.connectionString(),
            creationDate = javaType.creationDate(),
            disableIpMasking = javaType.disableIpMasking().map({ args0 -> args0 }).orElse(null),
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            flowType = javaType.flowType().map({ args0 -> args0 }).orElse(null),
            forceCustomerStorageForProfiler = javaType.forceCustomerStorageForProfiler().map({ args0 ->
                args0
            }).orElse(null),
            hockeyAppId = javaType.hockeyAppId().map({ args0 -> args0 }).orElse(null),
            hockeyAppToken = javaType.hockeyAppToken(),
            id = javaType.id(),
            immediatePurgeDataOn30Days = javaType.immediatePurgeDataOn30Days().map({ args0 ->
                args0
            }).orElse(null),
            ingestionMode = javaType.ingestionMode().map({ args0 -> args0 }).orElse(null),
            instrumentationKey = javaType.instrumentationKey(),
            kind = javaType.kind(),
            laMigrationDate = javaType.laMigrationDate(),
            location = javaType.location(),
            name = javaType.name(),
            privateLinkScopedResources = javaType.privateLinkScopedResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.PrivateLinkScopedResourceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccessForIngestion = javaType.publicNetworkAccessForIngestion().map({ args0 ->
                args0
            }).orElse(null),
            publicNetworkAccessForQuery = javaType.publicNetworkAccessForQuery().map({ args0 ->
                args0
            }).orElse(null),
            requestSource = javaType.requestSource().map({ args0 -> args0 }).orElse(null),
            retentionInDays = javaType.retentionInDays().map({ args0 -> args0 }).orElse(null),
            samplingPercentage = javaType.samplingPercentage().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
            workspaceResourceId = javaType.workspaceResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
