@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties that define a favorite that is associated to an Application Insights component.
 * @property category Favorite category, as defined by the user at creation time.
 * @property config Configuration of this particular favorite, which are driven by the Azure portal UX. Configuration data is a string containing valid JSON
 * @property favoriteId Internally assigned unique id of the favorite definition.
 * @property favoriteType Enum indicating if this favorite definition is owned by a specific user or is shared between all users with access to the Application Insights component.
 * @property isGeneratedFromTemplate Flag denoting wether or not this favorite was generated from a template.
 * @property name The user-defined name of the favorite.
 * @property sourceType The source of the favorite definition.
 * @property tags A list of 0 or more tags that are associated with this favorite definition
 * @property timeModified Date and time in UTC of the last modification that was made to this favorite definition.
 * @property userId Unique user id of the specific user that owns this favorite.
 * @property version This instance's version of the data model. This can change as new features are added that can be marked favorite. Current examples include MetricsExplorer (ME) and Search.
 */
public data class GetFavoriteResult(
    public val category: String? = null,
    public val config: String? = null,
    public val favoriteId: String,
    public val favoriteType: String? = null,
    public val isGeneratedFromTemplate: Boolean? = null,
    public val name: String? = null,
    public val sourceType: String? = null,
    public val tags: List<String>? = null,
    public val timeModified: String,
    public val userId: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetFavoriteResult): GetFavoriteResult = GetFavoriteResult(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            config = javaType.config().map({ args0 -> args0 }).orElse(null),
            favoriteId = javaType.favoriteId(),
            favoriteType = javaType.favoriteType().map({ args0 -> args0 }).orElse(null),
            isGeneratedFromTemplate = javaType.isGeneratedFromTemplate().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            sourceType = javaType.sourceType().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0 }),
            timeModified = javaType.timeModified(),
            userId = javaType.userId(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
