@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Virtual machine guest diagnostics settings resource.
 * @property dataSources the array of data source object which are configured to collect and send data
 * @property id Azure resource Id
 * @property location Resource location
 * @property name Azure resource name
 * @property osType Operating system type for the configuration
 * @property proxySetting
 * @property tags Resource tags
 * @property type Azure resource type
 */
public data class GetGuestDiagnosticsSettingResult(
    public val dataSources: List<DataSourceResponse>? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val osType: String? = null,
    public val proxySetting: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetGuestDiagnosticsSettingResult): GetGuestDiagnosticsSettingResult = GetGuestDiagnosticsSettingResult(
            dataSources = javaType.dataSources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.DataSourceResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            proxySetting = javaType.proxySetting().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
