@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An Azure Monitor PrivateLinkScope definition.
 * @property accessModeSettings Access mode settings
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property privateEndpointConnections List of private endpoint connections.
 * @property provisioningState Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed.
 * @property systemData System data
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetPrivateLinkScopeResult(
    public val accessModeSettings: AccessModeSettingsResponse,
    public val id: String,
    public val location: String,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetPrivateLinkScopeResult): GetPrivateLinkScopeResult = GetPrivateLinkScopeResult(
            accessModeSettings = javaType.accessModeSettings().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.AccessModeSettingsResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
