@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The scheduled query rule resource.
 * @property actions Actions to invoke when the alert fires.
 * @property autoMitigate The flag that indicates whether the alert should be automatically resolved or not. The default is true. Relevant only for rules of the kind LogAlert.
 * @property checkWorkspaceAlertsStorageConfigured The flag which indicates whether this scheduled query rule should be stored in the customer's storage. The default is false. Relevant only for rules of the kind LogAlert.
 * @property createdWithApiVersion The api-version used when creating this alert rule
 * @property criteria The rule criteria that defines the conditions of the scheduled query rule.
 * @property description The description of the scheduled query rule.
 * @property displayName The display name of the alert rule
 * @property enabled The flag which indicates whether this scheduled query rule is enabled. Value should be true or false
 * @property etag The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
 * @property evaluationFrequency How often the scheduled query rule is evaluated represented in ISO 8601 duration format. Relevant and required only for rules of the kind LogAlert.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity of the resource.
 * @property isLegacyLogAnalyticsRule True if alert rule is legacy Log Analytic rule
 * @property isWorkspaceAlertsStorageConfigured The flag which indicates whether this scheduled query rule has been configured to be stored in the customer's storage. The default is false.
 * @property kind Indicates the type of scheduled query rule. The default is LogAlert.
 * @property location The geo-location where the resource lives
 * @property muteActionsDuration Mute actions for the chosen period of time (in ISO 8601 duration format) after the alert is fired. Relevant only for rules of the kind LogAlert.
 * @property name The name of the resource
 * @property overrideQueryTimeRange If specified then overrides the query time range (default is WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert.
 * @property ruleResolveConfiguration Defines the configuration for resolving fired alerts. Relevant only for rules of the kind LogAlert.
 * @property scopes The list of resource id's that this scheduled query rule is scoped to.
 * @property severity Severity of the alert. Should be an integer between [0-4]. Value of 0 is severest. Relevant and required only for rules of the kind LogAlert.
 * @property skipQueryValidation The flag which indicates whether the provided query should be validated or not. The default is false. Relevant only for rules of the kind LogAlert.
 * @property systemData SystemData of ScheduledQueryRule.
 * @property tags Resource tags.
 * @property targetResourceTypes List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria. Relevant only for rules of the kind LogAlert
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property windowSize The period of time (in ISO 8601 duration format) on which the Alert query will be executed (bin size). Relevant and required only for rules of the kind LogAlert.
 */
public data class GetScheduledQueryRuleResult(
    public val actions: ActionsResponse? = null,
    public val autoMitigate: Boolean? = null,
    public val checkWorkspaceAlertsStorageConfigured: Boolean? = null,
    public val createdWithApiVersion: String,
    public val criteria: ScheduledQueryRuleCriteriaResponse,
    public val description: String? = null,
    public val displayName: String? = null,
    public val enabled: Boolean,
    public val etag: String,
    public val evaluationFrequency: String? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val isLegacyLogAnalyticsRule: Boolean,
    public val isWorkspaceAlertsStorageConfigured: Boolean,
    public val kind: String? = null,
    public val location: String,
    public val muteActionsDuration: String? = null,
    public val name: String,
    public val overrideQueryTimeRange: String? = null,
    public val ruleResolveConfiguration: RuleResolveConfigurationResponse? = null,
    public val scopes: List<String>,
    public val severity: Double? = null,
    public val skipQueryValidation: Boolean? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val targetResourceTypes: List<String>? = null,
    public val type: String,
    public val windowSize: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetScheduledQueryRuleResult): GetScheduledQueryRuleResult = GetScheduledQueryRuleResult(
            actions = javaType.actions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.ActionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            autoMitigate = javaType.autoMitigate().map({ args0 -> args0 }).orElse(null),
            checkWorkspaceAlertsStorageConfigured = javaType.checkWorkspaceAlertsStorageConfigured().map({ args0 ->
                args0
            }).orElse(null),
            createdWithApiVersion = javaType.createdWithApiVersion(),
            criteria = javaType.criteria().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.ScheduledQueryRuleCriteriaResponse.Companion.toKotlin(args0)
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled(),
            etag = javaType.etag(),
            evaluationFrequency = javaType.evaluationFrequency().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isLegacyLogAnalyticsRule = javaType.isLegacyLogAnalyticsRule(),
            isWorkspaceAlertsStorageConfigured = javaType.isWorkspaceAlertsStorageConfigured(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            muteActionsDuration = javaType.muteActionsDuration().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            overrideQueryTimeRange = javaType.overrideQueryTimeRange().map({ args0 -> args0 }).orElse(null),
            ruleResolveConfiguration = javaType.ruleResolveConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.RuleResolveConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scopes = javaType.scopes().map({ args0 -> args0 }),
            severity = javaType.severity().map({ args0 -> args0 }).orElse(null),
            skipQueryValidation = javaType.skipQueryValidation().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetResourceTypes = javaType.targetResourceTypes().map({ args0 -> args0 }),
            type = javaType.type(),
            windowSize = javaType.windowSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
