@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A tenant action group resource.
 * @property azureAppPushReceivers The list of AzureAppPush receivers that are part of this tenant action group.
 * @property emailReceivers The list of email receivers that are part of this tenant action group.
 * @property enabled Indicates whether this tenant action group is enabled. If a tenant action group is not enabled, then none of its receivers will receive communications.
 * @property groupShortName The short name of the action group. This will be used in SMS messages.
 * @property id Azure resource Id
 * @property location Resource location
 * @property name Azure resource name
 * @property smsReceivers The list of SMS receivers that are part of this tenant action group.
 * @property tags Resource tags
 * @property type Azure resource type
 * @property voiceReceivers The list of voice receivers that are part of this tenant action group.
 * @property webhookReceivers The list of webhook receivers that are part of this tenant action group.
 */
public data class GetTenantActionGroupResult(
    public val azureAppPushReceivers: List<AzureAppPushReceiverResponse>? = null,
    public val emailReceivers: List<EmailReceiverResponse>? = null,
    public val enabled: Boolean,
    public val groupShortName: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val smsReceivers: List<SmsReceiverResponse>? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val voiceReceivers: List<VoiceReceiverResponse>? = null,
    public val webhookReceivers: List<WebhookReceiverResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetTenantActionGroupResult): GetTenantActionGroupResult = GetTenantActionGroupResult(
            azureAppPushReceivers = javaType.azureAppPushReceivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.AzureAppPushReceiverResponse.Companion.toKotlin(args0)
                })
            }),
            emailReceivers = javaType.emailReceivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.EmailReceiverResponse.Companion.toKotlin(args0)
                })
            }),
            enabled = javaType.enabled(),
            groupShortName = javaType.groupShortName(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            smsReceivers = javaType.smsReceivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.SmsReceiverResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            voiceReceivers = javaType.voiceReceivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.VoiceReceiverResponse.Companion.toKotlin(args0)
                })
            }),
            webhookReceivers = javaType.webhookReceivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.WebhookReceiverResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
