@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An Application Insights WebTest definition.
 * @property configuration An XML configuration specification for a WebTest.
 * @property description User defined description for this WebTest.
 * @property enabled Is the test actively being monitored.
 * @property frequency Interval in seconds between test runs for this WebTest. Default value is 300.
 * @property id Azure resource Id
 * @property kind The kind of WebTest that this web test watches. Choices are ping, multistep and standard.
 * @property location Resource location
 * @property locations A list of where to physically run the tests from to give global coverage for accessibility of your application.
 * @property name Azure resource name
 * @property provisioningState Current state of this component, whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
 * @property request The collection of request properties
 * @property retryEnabled Allow for retries should this WebTest fail.
 * @property syntheticMonitorId Unique ID of this WebTest. This is typically the same value as the Name field.
 * @property tags Resource tags
 * @property timeout Seconds until this WebTest will timeout and fail. Default value is 30.
 * @property type Azure resource type
 * @property validationRules The collection of validation rule properties
 * @property webTestKind The kind of web test this is, valid choices are ping, multistep and standard.
 * @property webTestName User defined name if this WebTest.
 */
public data class GetWebTestResult(
    public val configuration: WebTestPropertiesResponseConfiguration? = null,
    public val description: String? = null,
    public val enabled: Boolean? = null,
    public val frequency: Int? = null,
    public val id: String,
    public val kind: String? = null,
    public val location: String,
    public val locations: List<WebTestGeolocationResponse>,
    public val name: String,
    public val provisioningState: String,
    public val request: WebTestPropertiesResponseRequest? = null,
    public val retryEnabled: Boolean? = null,
    public val syntheticMonitorId: String,
    public val tags: Map<String, String>? = null,
    public val timeout: Int? = null,
    public val type: String,
    public val validationRules: WebTestPropertiesResponseValidationRules? = null,
    public val webTestKind: String,
    public val webTestName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetWebTestResult): GetWebTestResult = GetWebTestResult(
            configuration = javaType.configuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.WebTestPropertiesResponseConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            frequency = javaType.frequency().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            locations = javaType.locations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.WebTestGeolocationResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            request = javaType.request().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.WebTestPropertiesResponseRequest.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retryEnabled = javaType.retryEnabled().map({ args0 -> args0 }).orElse(null),
            syntheticMonitorId = javaType.syntheticMonitorId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            validationRules = javaType.validationRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.WebTestPropertiesResponseValidationRules.Companion.toKotlin(args0)
                })
            }).orElse(null),
            webTestKind = javaType.webTestKind(),
            webTestName = javaType.webTestName(),
        )
    }
}
