@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A header to add to the WebTest.
 * @property headerFieldName The name of the header.
 * @property headerFieldValue The value of the header.
 */
public data class HeaderFieldResponse(
    public val headerFieldName: String? = null,
    public val headerFieldValue: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.HeaderFieldResponse): HeaderFieldResponse = HeaderFieldResponse(
            headerFieldName = javaType.headerFieldName().map({ args0 -> args0 }).orElse(null),
            headerFieldValue = javaType.headerFieldValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
