@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An Itsm receiver.
 * @property connectionId Unique identification of ITSM connection among multiple defined in above workspace.
 * @property name The name of the Itsm receiver. Names must be unique across all receivers within an action group.
 * @property region Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
 * @property ticketConfiguration JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
 * @property workspaceId OMS LA instance identifier.
 */
public data class ItsmReceiverResponse(
    public val connectionId: String,
    public val name: String,
    public val region: String,
    public val ticketConfiguration: String,
    public val workspaceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ItsmReceiverResponse): ItsmReceiverResponse = ItsmReceiverResponse(
            connectionId = javaType.connectionId(),
            name = javaType.name(),
            region = javaType.region(),
            ticketConfiguration = javaType.ticketConfiguration(),
            workspaceId = javaType.workspaceId(),
        )
    }
}
