@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property location Name of location.
 * @property provisioningStatus The resource provisioning state in this location.
 */
public data class LocationSpecResponse(
    public val location: String? = null,
    public val provisioningStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.LocationSpecResponse): LocationSpecResponse = LocationSpecResponse(
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            provisioningStatus = javaType.provisioningStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
