@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A rule condition based on a certain number of locations failing.
 * @property dataSource the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
 * @property failedLocationCount the number of locations that must fail to activate the alert.
 * @property odataType specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
 * Expected value is 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition'.
 * @property windowSize the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
 */
public data class LocationThresholdRuleConditionResponse(
    public val dataSource: Either<RuleManagementEventDataSourceResponse, RuleMetricDataSourceResponse>? = null,
    public val failedLocationCount: Int,
    public val odataType: String,
    public val windowSize: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.LocationThresholdRuleConditionResponse): LocationThresholdRuleConditionResponse = LocationThresholdRuleConditionResponse(
            dataSource = javaType.dataSource().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.insights.kotlin.outputs.RuleManagementEventDataSourceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.insights.kotlin.outputs.RuleMetricDataSourceResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            failedLocationCount = javaType.failedLocationCount(),
            odataType = javaType.odataType(),
            windowSize = javaType.windowSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
