@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies the metric alert criteria for a single resource that has multiple metric criteria.
 * @property allOf The list of metric criteria for this 'all of' operation.
 * @property odataType specifies the type of the alert criteria.
 * Expected value is 'Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria'.
 */
public data class MetricAlertSingleResourceMultipleMetricCriteriaResponse(
    public val allOf: List<MetricCriteriaResponse>? = null,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.MetricAlertSingleResourceMultipleMetricCriteriaResponse): MetricAlertSingleResourceMultipleMetricCriteriaResponse =
            MetricAlertSingleResourceMultipleMetricCriteriaResponse(
                allOf = javaType.allOf().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.insights.kotlin.outputs.MetricCriteriaResponse.Companion.toKotlin(args0)
                    })
                }),
                odataType = javaType.odataType(),
            )
    }
}
