@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Criterion to filter metrics.
 * @property criterionType Specifies the type of threshold criteria
 * Expected value is 'StaticThresholdCriterion'.
 * @property dimensions List of dimension conditions.
 * @property metricName Name of the metric.
 * @property metricNamespace Namespace of the metric.
 * @property name Name of the criteria.
 * @property operator the criteria operator.
 * @property skipMetricValidation Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
 * @property threshold the criteria threshold value that activates the alert.
 * @property timeAggregation the criteria time aggregation types.
 */
public data class MetricCriteriaResponse(
    public val criterionType: String,
    public val dimensions: List<MetricDimensionResponse>? = null,
    public val metricName: String,
    public val metricNamespace: String? = null,
    public val name: String,
    public val `operator`: String,
    public val skipMetricValidation: Boolean? = null,
    public val threshold: Double,
    public val timeAggregation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.MetricCriteriaResponse): MetricCriteriaResponse = MetricCriteriaResponse(
            criterionType = javaType.criterionType(),
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.MetricDimensionResponse.Companion.toKotlin(args0)
                })
            }),
            metricName = javaType.metricName(),
            metricNamespace = javaType.metricNamespace().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            `operator` = javaType.`operator`(),
            skipMetricValidation = javaType.skipMetricValidation().map({ args0 -> args0 }).orElse(null),
            threshold = javaType.threshold(),
            timeAggregation = javaType.timeAggregation(),
        )
    }
}
