@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.
 * @property category Name of a Diagnostic Metric category for a resource type this setting is applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a GET diagnostic settings operation.
 * @property enabled a value indicating whether this category is enabled.
 * @property retentionPolicy the retention policy for this category.
 * @property timeGrain the timegrain of the metric in ISO8601 format.
 */
public data class MetricSettingsResponse(
    public val category: String? = null,
    public val enabled: Boolean,
    public val retentionPolicy: RetentionPolicyResponse? = null,
    public val timeGrain: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.MetricSettingsResponse): MetricSettingsResponse = MetricSettingsResponse(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled(),
            retentionPolicy = javaType.retentionPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.RetentionPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timeGrain = javaType.timeGrain().map({ args0 -> args0 }).orElse(null),
        )
    }
}
