@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Monitoring account destination.
 * @property accountId The immutable ID  of the account.
 * @property accountResourceId The resource ID of the monitoring account.
 * @property name A friendly name for the destination.
 * This name should be unique across all destinations (regardless of type) within the data collection rule.
 */
public data class MonitoringAccountDestinationResponse(
    public val accountId: String,
    public val accountResourceId: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.MonitoringAccountDestinationResponse): MonitoringAccountDestinationResponse = MonitoringAccountDestinationResponse(
            accountId = javaType.accountId(),
            accountResourceId = javaType.accountResourceId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
