@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Customer Managed Identity
 * @property principalId The principal ID of resource identity.
 * @property tenantId The tenant ID of resource.
 */
public data class MyWorkbookUserAssignedIdentitiesResponse(
    public val principalId: String,
    public val tenantId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.MyWorkbookUserAssignedIdentitiesResponse): MyWorkbookUserAssignedIdentitiesResponse = MyWorkbookUserAssignedIdentitiesResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
        )
    }
}
