@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Definition of platform telemetry data source configuration
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property streams List of platform telemetry streams to collect
 */
public data class PlatformTelemetryDataSourceResponse(
    public val name: String? = null,
    public val streams: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.PlatformTelemetryDataSourceResponse): PlatformTelemetryDataSourceResponse = PlatformTelemetryDataSourceResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            streams = javaType.streams().map({ args0 -> args0 }),
        )
    }
}
