@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property resourceId The resourceId of the Azure Monitor Private Link Scope Scoped Resource through which this DCE is associated with a Azure Monitor Private Link Scope.
 * @property scopeId The immutableId of the Azure Monitor Private Link Scope Resource to which the association is.
 */
public data class PrivateLinkScopedResourceResponse(
    public val resourceId: String? = null,
    public val scopeId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.PrivateLinkScopedResourceResponse): PrivateLinkScopedResourceResponse = PrivateLinkScopedResourceResponse(
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            scopeId = javaType.scopeId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
