@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Definition of Prometheus metrics forwarding configuration.
 * @property labelIncludeFilter The list of label inclusion filters in the form of label "name-value" pairs.
 * Currently only one label is supported: 'microsoft_metrics_include_label'.
 * Label values are matched case-insensitively.
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property streams List of streams that this data source will be sent to.
 */
public data class PrometheusForwarderDataSourceResponse(
    public val labelIncludeFilter: Map<String, String>? = null,
    public val name: String? = null,
    public val streams: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.PrometheusForwarderDataSourceResponse): PrometheusForwarderDataSourceResponse = PrometheusForwarderDataSourceResponse(
            labelIncludeFilter = javaType.labelIncludeFilter().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            streams = javaType.streams().map({ args0 -> args0 }),
        )
    }
}
