@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The repeating times at which this profile begins. This element is not used if the FixedDate element is used.
 * @property frequency the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly.
 * @property schedule the scheduling constraints for when the profile begins.
 */
public data class RecurrenceResponse(
    public val frequency: String,
    public val schedule: RecurrentScheduleResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.RecurrenceResponse): RecurrenceResponse = RecurrenceResponse(
            frequency = javaType.frequency(),
            schedule = javaType.schedule().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.RecurrentScheduleResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
