@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A rule management event data source. The discriminator fields is always RuleManagementEventDataSource in this case.
 * @property claims the claims.
 * @property eventName the event name.
 * @property eventSource the event source.
 * @property legacyResourceId the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
 * @property level the level.
 * @property metricNamespace the namespace of the metric.
 * @property odataType specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
 * Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource'.
 * @property operationName The name of the operation that should be checked for. If no name is provided, any operation will match.
 * @property resourceGroupName the resource group name.
 * @property resourceLocation the location of the resource.
 * @property resourceProviderName the resource provider name.
 * @property resourceUri the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
 * @property status The status of the operation that should be checked for. If no status is provided, any status will match.
 * @property subStatus the substatus.
 */
public data class RuleManagementEventDataSourceResponse(
    public val claims: RuleManagementEventClaimsDataSourceResponse? = null,
    public val eventName: String? = null,
    public val eventSource: String? = null,
    public val legacyResourceId: String? = null,
    public val level: String? = null,
    public val metricNamespace: String? = null,
    public val odataType: String,
    public val operationName: String? = null,
    public val resourceGroupName: String? = null,
    public val resourceLocation: String? = null,
    public val resourceProviderName: String? = null,
    public val resourceUri: String? = null,
    public val status: String? = null,
    public val subStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.RuleManagementEventDataSourceResponse): RuleManagementEventDataSourceResponse = RuleManagementEventDataSourceResponse(
            claims = javaType.claims().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.RuleManagementEventClaimsDataSourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            eventName = javaType.eventName().map({ args0 -> args0 }).orElse(null),
            eventSource = javaType.eventSource().map({ args0 -> args0 }).orElse(null),
            legacyResourceId = javaType.legacyResourceId().map({ args0 -> args0 }).orElse(null),
            level = javaType.level().map({ args0 -> args0 }).orElse(null),
            metricNamespace = javaType.metricNamespace().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
            operationName = javaType.operationName().map({ args0 -> args0 }).orElse(null),
            resourceGroupName = javaType.resourceGroupName().map({ args0 -> args0 }).orElse(null),
            resourceLocation = javaType.resourceLocation().map({ args0 -> args0 }).orElse(null),
            resourceProviderName = javaType.resourceProviderName().map({ args0 -> args0 }).orElse(null),
            resourceUri = javaType.resourceUri().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            subStatus = javaType.subStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
