@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A rule metric data source. The discriminator value is always RuleMetricDataSource in this case.
 * @property legacyResourceId the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
 * @property metricName the name of the metric that defines what the rule monitors.
 * @property metricNamespace the namespace of the metric.
 * @property odataType specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
 * Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource'.
 * @property resourceLocation the location of the resource.
 * @property resourceUri the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
 */
public data class RuleMetricDataSourceResponse(
    public val legacyResourceId: String? = null,
    public val metricName: String? = null,
    public val metricNamespace: String? = null,
    public val odataType: String,
    public val resourceLocation: String? = null,
    public val resourceUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.RuleMetricDataSourceResponse): RuleMetricDataSourceResponse = RuleMetricDataSourceResponse(
            legacyResourceId = javaType.legacyResourceId().map({ args0 -> args0 }).orElse(null),
            metricName = javaType.metricName().map({ args0 -> args0 }).orElse(null),
            metricNamespace = javaType.metricNamespace().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
            resourceLocation = javaType.resourceLocation().map({ args0 -> args0 }).orElse(null),
            resourceUri = javaType.resourceUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
