@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * TBD. Relevant only for rules of the kind LogAlert.
 * @property autoResolved The flag that indicates whether or not to auto resolve a fired alert.
 * @property timeToResolve The duration a rule must evaluate as healthy before the fired alert is automatically resolved represented in ISO 8601 duration format.
 */
public data class RuleResolveConfigurationResponse(
    public val autoResolved: Boolean? = null,
    public val timeToResolve: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.RuleResolveConfigurationResponse): RuleResolveConfigurationResponse = RuleResolveConfigurationResponse(
            autoResolved = javaType.autoResolved().map({ args0 -> args0 }).orElse(null),
            timeToResolve = javaType.timeToResolve().map({ args0 -> args0 }).orElse(null),
        )
    }
}
