@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The parameters for the scaling action.
 * @property cooldown the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
 * @property direction the scale direction. Whether the scaling action increases or decreases the number of instances.
 * @property type the type of action that should occur when the scale rule fires.
 * @property value the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1.
 */
public data class ScaleActionResponse(
    public val cooldown: String,
    public val direction: String,
    public val type: String,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ScaleActionResponse): ScaleActionResponse = ScaleActionResponse(
            cooldown = javaType.cooldown(),
            direction = javaType.direction(),
            type = javaType.type(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
